<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Unit Cargo - Logistics</title>
	<!-- ========== Favicon Icon ========== -->
    <link rel="shortcut icon" href="assets/img/favicon.jpg">
	<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body>

	<div class="container my-5">
		<h1>Client Information</h1>
		<a class="btn btn-primary" href="/logistics/create.php" role="button">New Client</a>
		<br>
		<table class="table">
			<thead>
				<tr>
					<th>TRACK ID</th>
					<th>COURIER</th>
					<th>PACKAGE</th>
					<th>MODE</th>
					<th>PRODUCT</th>
					<th>QUANTITY</th>
					<th>TOTALFREIGHT</th>
					<th>COURIER REF NO</th>
					<th>Action</th>
				</tr>
			</thead>
			<tbody>
				<?php
				include_once('connection.php');

				// Check connection
				if ($con->connect_error) {
					die("Connection failed: " . $con->connect_error);
				}

				// Read all rows from the database table
				$acct = "select * from consignment_details"; 
				$result = $con->query($acct);

				// Read data of each row
				while ($row = $result->fetch_assoc()) {
					echo "
					<tr>
						<td>" . htmlspecialchars($row['trackid']) . "</td>
						<td>" . htmlspecialchars($row['courier']) . "</td>
						<td>" . htmlspecialchars($row['package']) . "</td>
						<td>" . htmlspecialchars($row['mode']) . "</td>
						<td>" . htmlspecialchars($row['product']) . "</td>
						<td>" . htmlspecialchars($row['quantity']) . "</td>
						<td>" . htmlspecialchars($row['totalfreight']) . "</td>
						<td>" . htmlspecialchars($row['crn']) . "</td>
						<td>
							<a class='btn btn-primary btn-sm' href='/logistics/edits.php?trackid=" . urlencode($row['trackid']) . "'>Edit</a>
							<a class='btn btn-danger btn-sm' href='/logistics/delete.php?trackid=" . urlencode($row['trackid']) . "'>Delete</a>
						</td>
					</tr>
					";
				}

				?>
			</tbody>
		</table>
	</div>

</body>
</html>