<?php
include_once('connection.php');

$trackid = "";
$courier = "";
$package = "";
$mode = "";
$product = "";
$quantity = "";
$totalfreight = "";
$crn = "";
$errorMessage = "";
$successMessage = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $trackid = $_POST["trackid"];
    $courier = $_POST["courier"];
    $package = $_POST["package"];
    $mode = $_POST["mode"];
    $product = $_POST["product"];
    $quantity = $_POST["quantity"];
    $totalfreight = $_POST["totalfreight"];
    $crn = $_POST["crn"];

    do {
        if (empty($trackid) || empty($courier) || empty($package) || empty($mode) || empty($product) || empty($quantity) || empty($totalfreight) || empty($crn)) {
            $errorMessage = "All fields are required";
            break;
        }

        // Add a new consignment using prepared statement
        $sql = "INSERT INTO consignment_details (trackid, courier, package, mode, product, quantity, totalfreight, crn) " .
            "VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $con->prepare($sql);
        $stmt->bind_param("ssssssss", $trackid, $courier, $package, $mode, $product, $quantity, $totalfreight, $crn);
        $result = $stmt->execute();

        if (!$result) {
            $errorMessage = "Invalid query: " . $stmt->error;
            break;
        }

        $successMessage = "Consignment added correctly";

        header("location: /logistics/Admins.php");
        exit;

    } while (false);
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Unit Cargo - Logistics</title>
    <link rel="shortcut icon" href="assets/img/favicon.jpg">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</head>

<body>
    <div class="container my-5">
        <h2>New Consignment</h2>

        <?php
        if (!empty($errorMessage)) {
            echo "
            <div class='alert alert-warning alert-dismissible fade show' role='alert'>
                <strong>$errorMessage</strong>
                <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='close'></button>
            </div> 
            ";
        }

        if (!empty($successMessage)) {
            echo "
            <div class='alert alert-success alert-dismissible fade show' role='alert'>
                <strong>$successMessage</strong>
                <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='close'></button>
            </div> 
            ";
        }
        ?>
		<form method="post">
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Track Id</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="trackid" value="<?php echo $trackid; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Courier</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="courier" value="<?php echo $courier; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Package</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="package" value="<?php echo $package; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Mode</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="mode" value="<?php echo $mode; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Product</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="product" value="<?php echo $product; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Quantity</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="quantity" value="<?php echo $quantity; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Total-Freight</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="totalfreight" value="<?php echo $totalfreight; ?>">
				</div>
			</div>
			<div class="row mb-3">
				<label class="col-sm-3 col-form-label">Courier Ref No</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" name="crn" value="<?php echo $crn; ?>">
				</div>
			</div>
			<?php
				if ( !empty($successMessage) ) {

				}
			?>

			<div class="row mb-3">
				<div class="offset-sm-3 col-sm-3 d-grid">
					<button type="submit" class="btn btn-primary">Submit</button>
				</div>
				<div class="col-sm-3 d-grid">
					<a class="btn btn-outline-primary" href="/logistics/Admins.php" role="button">Cancel</a>
				</div>

			</div>
		</form>
	</div>

</body>
</html>